package ru.yandex.webmaster.common.host;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import ru.yandex.wmconsole.data.HostInfoStatusEnum;
import ru.yandex.wmconsole.data.UpdateStateEnum;
import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.info.HostStatusInfo;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;

/**
 * Represents node in sitelist forest.
 *
 * User: azakharov
 * Date: 15.01.14
 * Time: 19:01
 */
public class HostNodeInfo implements Comparable<HostNodeInfo> {

    // user db info
    private final long hostId;
    private final String hostName;
    private final Long mainMirrorHostId;
    private final String mainMirrorHostName;
    private final VerificationStateEnum verificationState;
    private final VerificationTypeEnum verificationType;

    private UpdateStateEnum updateState;
    private Long urls;
    private boolean isVirused;
    private Integer tcy;
    private Long indexCount;
    private Date indexCountCacheUpdateTime;
    private String spiderIp;
    private Date lastAccess;
    private HostStatusInfo hostStatusInfo;
    private Date hostInfoStatusDate;

    private final List<HostNodeInfo> children = new ArrayList<>();

    private final String sortString;

    public HostNodeInfo(long hostId, String hostName, Long mainMirrorHostId, String mainMirrorHostName, VerificationStateEnum verificationState, VerificationTypeEnum verificationType) {
        this.hostId = hostId;
        this.hostName = hostName;
        this.mainMirrorHostId = mainMirrorHostId;
        this.mainMirrorHostName = mainMirrorHostName;
        this.verificationState = verificationState;
        this.verificationType = verificationType;

        String hostMainPart = hostName.toLowerCase();
        final String protocolSeparator = "://";
        int idx = hostMainPart.indexOf(protocolSeparator);
        if (idx >= 0) {
            hostMainPart = hostMainPart.substring(idx + protocolSeparator.length());
        }
        idx = hostMainPart.indexOf(":");
        if (idx >= 0) {
            hostMainPart = hostMainPart.substring(0, idx);
        }
        sortString = hostMainPart + " " + hostName;
    }

    public long getHostId() {
        return hostId;
    }

    public String getHostName() {
        return hostName;
    }

    public Long getMainMirrorHostId() {
        return mainMirrorHostId;
    }

    public String getMainMirrorHostName() {
        return mainMirrorHostName;
    }

    public VerificationStateEnum getVerificationState() {
        return verificationState;
    }

    public VerificationTypeEnum getVerificationType() {
        return verificationType;
    }

    public void setHostDbFields(final HostDbHostInfo hostDbHostInfo,
                                final UpdateStateEnum updateState, final Long urls,
                                final boolean isVirused, final Integer tcy,
                                final Long indexCount,
                                final Date indexCountCacheUpdateTime,
                                HostInfoStatusEnum hostInfoStatus,
                                Date hostInfoStatusDate,
                                String spiderIp,
                                HostInfoStatusEnum hostInfoStatusHtarc, final Integer penaltyHtarc,
                                HostInfoStatusEnum hostInfoStatusYa, final Integer penaltyYa,
                                final Date lastAccess,
                                Boolean htarcInIndex,
                                Boolean prevInIndex) {

        this.updateState = updateState;
        this.urls = urls;
        this.isVirused = isVirused;
        this.tcy = tcy;
        this.indexCount = indexCount;
        this.indexCountCacheUpdateTime = indexCountCacheUpdateTime;
        this.spiderIp = spiderIp;
        this.lastAccess = lastAccess;
        this.hostStatusInfo = new HostStatusInfo(
                hostInfoStatusHtarc, hostInfoStatusYa, hostInfoStatus, penaltyHtarc, penaltyYa, htarcInIndex, prevInIndex);
        this.hostInfoStatusDate = hostInfoStatusDate;
    }

    public void addNode(HostNodeInfo node) {
        children.add(node);
    }

    public List<HostNodeInfo> getChildren() {
        return children;
    }

    @Override
    public int compareTo(HostNodeInfo o) {
        if (o == null) {
            return -1;
        }

        if (hostId == o.getHostId()) {
            return 0;
        }

        return sortString.compareTo(o.sortString);
    }

    public UpdateStateEnum getUpdateState() {
        return updateState;
    }

    public Long getUrls() {
        return urls;
    }

    public boolean isVirused() {
        return isVirused;
    }

    public Integer getTcy() {
        return tcy;
    }

    public void setTcy(Integer tcy) {
        this.tcy = tcy;
    }

    public Long getIndexCount() {
        return indexCount;
    }

    public void setIndexCount(Long indexCount) {
        this.indexCount = indexCount;
    }

    public Date getIndexCountCacheUpdateTime() {
        return indexCountCacheUpdateTime;
    }

    public HostInfoStatusEnum getHostInfoStatus() {
        if (hostStatusInfo == null) {
            return null;
        }
        return hostStatusInfo.getHostInfoStatus();
    }

    public HostInfoStatusEnum getCalculatedHostInfoStatus() {
        if (hostStatusInfo == null) {
            return null;
        }
        return hostStatusInfo.getCalculatedHostInfoStatus();
    }

    public String getSpiderIp() {
        return spiderIp;
    }

    public Date getLastAccess() {
        return lastAccess;
    }

    public Date getHostInfoStatusDate() {
        return hostInfoStatusDate;
    }

    public void setVirused(boolean isVirused) {
        this.isVirused = isVirused;
    }
}
