package ru.yandex.webmaster.common.host.dao;

import java.util.HashSet;
import java.util.Set;

import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.webmaster.common.host.HostEventType;
import ru.yandex.wmconsole.data.info.BriefHostInfo;

/**
 * @author aherman
 */
public class TblHostEventConditions {
    public static SqlCondition eventId(int eventId) {
        return SqlCondition.column("event_id").eq(eventId);
    }

    public static SqlCondition type(HostEventType eventType) {
        return SqlCondition.column("event_type").eq(eventType.value());
    }

    public static SqlCondition eventIdGreaterThan(int eventId) {
        return SqlCondition.column("event_id").gt(eventId);
    }

    public static SqlCondition hostId(BriefHostInfo briefHostInfo) {
        return SqlCondition.column("host_id").eq(briefHostInfo.getId());
    }

    public static SqlCondition eventTypeIn(Set<HostEventType> eventTypes) {
        if (eventTypes.isEmpty()) {
            return SqlCondition.falseCondition();
        }

        Set<Integer> ids = new HashSet<>(eventTypes.size());
        for (HostEventType eventType : eventTypes) {
            ids.add(eventType.value());
        }

        return SqlCondition.column("event_type").inSet(ids);
    }

    public static SqlCondition eventFroUserId(long userId) {
        return SqlCondition.column("event_for_user_id").eq(userId);
    }
}
