package ru.yandex.webmaster.common.http;

import java.util.LinkedList;
import java.util.List;


/**
 * @author aherman
 */
public abstract class Action<RequestType extends ActionRequest, ResponseType extends ActionResponse> {
    public abstract ResponseType process(RequestType request) throws Exception;

    public List<Class<? extends RequestFilter>> getRequestFilters() {
        return new LinkedList<>();
    }

    public List<Class<? extends ResponseFilter>> getResponseFilters() {
        return new LinkedList<>();
    }
}
