package ru.yandex.webmaster.common.http;

import org.joda.time.DateTime;
import org.joda.time.Instant;

import ru.yandex.webmaster.common.WebmasterActionException;
import ru.yandex.webmaster.common.WebmasterExceptionType;

/**
 * @author aherman
 */
public class DateTimeParameterConverter implements ParameterConverter {
    @Override
    public Object convert(String name, String value, Class<?> toType) {
        try {
            if (toType == Instant.class) {
                return Instant.parse(value);
            } else if (toType == DateTime.class) {
                return DateTime.parse(value);
            }
        } catch (IllegalArgumentException e) {
            throw new WebmasterActionException(WebmasterExceptionType.REQUEST__ILLEGAL_PARAMETER_VALUE,
                    "Unable to convert to date: " + value, e, "name", name, "value", value);
        }
        return null;
    }
}
