package ru.yandex.webmaster.common.newwmc;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;

/**
 * @author avhaliullin
 */
public class VerificationView {
    private final long id;
    private final long userId;
    private final String hostName;
    private final VerificationTypeEnum verificationType;
    private final VerificationStateEnum verificationState;
    private final Long verifiedAt;
    private final long verificationUin;

    public VerificationView(
            @JsonProperty("id") long id,
            @JsonProperty("userId") long userId,
            @JsonProperty("hostName") String hostName,
            @JsonProperty("verificationType") VerificationTypeEnum verificationType,
            @JsonProperty("verificationState") VerificationStateEnum verificationState,
            @JsonProperty("verifiedAt") Long verifiedAt,
            @JsonProperty("verificationUin") long verificationUin
    ) {
        this.id = id;
        this.userId = userId;
        this.hostName = hostName;
        this.verificationType = verificationType;
        this.verificationState = verificationState;
        this.verifiedAt = verifiedAt;
        this.verificationUin = verificationUin;
    }

    public long getUserId() {
        return userId;
    }

    public String getHostName() {
        return hostName;
    }

    public VerificationTypeEnum getVerificationType() {
        return verificationType;
    }

    public VerificationStateEnum getVerificationState() {
        return verificationState;
    }

    public Long getVerifiedAt() {
        return verifiedAt;
    }

    public long getVerificationUin() {
        return verificationUin;
    }

    public long getId() {
        return id;
    }
}
