package ru.yandex.webmaster.common.sitemap;

import java.util.Date;

/**
* @author aherman
*/
public class ExtendedSitemapInfo extends ShortSitemapInfo {
    private final Date submittedOn;
    private final String sitemapHostName;
    private final String sitemapUrlName;

    public ExtendedSitemapInfo(long id, Long indexId, Long indexIdCount, boolean fromRobotsTxt, boolean fromUser,
            String sitemapHostName,
            String sitemapUrlName, Date submittedOn) {
        super(id, indexId, indexIdCount, fromRobotsTxt, fromUser);
        this.sitemapHostName = sitemapHostName;
        this.sitemapUrlName = sitemapUrlName;
        this.submittedOn = submittedOn;
    }

    public Date getSubmittedOn() {
        return submittedOn;
    }

    public String getSitemapHostName() {
        return sitemapHostName;
    }

    public String getSitemapUrlName() {
        return sitemapUrlName;
    }
}
