package ru.yandex.webmaster.common.sitemap;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;
import ru.yandex.wmtools.common.util.SqlUtil;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * @author avhaliullin
 */
public class TblRemovedUserSitemapsDao extends AbstractDbService {
    private static final String T_REMOVED_SITEMAPS = "tbl_removed_user_sitemaps";

    public Map<Long, List<RemovedUserSitemap>> listRemovedSitemapsForHosts(List<BriefHostInfo> hosts) throws InternalException {
        if (hosts.isEmpty()) {
            return Collections.emptyMap();
        }
        Long[] hostIds = new Long[hosts.size()];
        for (int i = 0; i < hosts.size(); i++) {
            hostIds[i] = hosts.get(i).getId();
        }
        String query = "SELECT host_id, user_id, sitemap_url, remove_date FROM " + T_REMOVED_SITEMAPS +
                "   WHERE host_id IN (" + SqlUtil.createQuestionMarks(hosts.size()) + ")";
        List<RemovedUserSitemap> sitemapsList = getJdbcTemplate(WMCPartition.nullPartition())
                .query(query, MAPPER, hostIds);
        Map<Long, List<RemovedUserSitemap>> result = new HashMap<>();
        for (RemovedUserSitemap sitemap : sitemapsList) {
            List<RemovedUserSitemap> sitemapsForHost = result.get(sitemap.getHostId());
            if (sitemapsForHost == null) {
                sitemapsForHost = new ArrayList<>();
                result.put(sitemap.getHostId(), sitemapsForHost);
            }
            sitemapsForHost.add(sitemap);
        }
        return result;
    }

    public void addRemovedSitemap(BriefHostInfo hostInfo, String sitemapUrl, long userId) throws InternalException {
        String query = "INSERT INTO " + T_REMOVED_SITEMAPS + " (host_id, user_id, sitemap_url, remove_date) VALUES (?,?,?,NOW()) " +
                "ON DUPLICATE KEY UPDATE remove_date=VALUES(remove_date), user_id=VALUES(user_id)";
        getJdbcTemplate(WMCPartition.nullPartition()).update(query, hostInfo.getId(), userId, sitemapUrl);
    }

    private static final ParameterizedRowMapper<RemovedUserSitemap> MAPPER = new ParameterizedRowMapper<RemovedUserSitemap>() {
        @Override
        public RemovedUserSitemap mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new RemovedUserSitemap(
                    rs.getLong("host_id"),
                    rs.getString("sitemap_url"),
                    rs.getTimestamp("remove_date"),
                    rs.getLong("user_id")
            );
        }
    };
}
