package ru.yandex.webmaster.common.urltree;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum YandexSearchShard implements IntEnum {
    RU(0),
    UA(1),
    COM(2),
    COM_TR(3),;

    private YandexSearchShard(int value) {
        this.value = value;
    }

    private final int value;

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<YandexSearchShard> R = IntEnumResolver.r(YandexSearchShard.class);

    public static YandexSearchShard getByName(String name) {
        for (YandexSearchShard value : values()) {
            if (value.name().toLowerCase().equals(name)) {
                return value;
            }
        }
        return null;
    }
}
