package ru.yandex.webmaster.common.util;

import java.net.IDN;

/**
 * @author aherman
 */
public class Hostname {
    public static final String WWW = "www.";

    private final String scheme;
    private final String hostname;
    private final int port;

    private final boolean punycoded;

    private final boolean www;


    Hostname(String scheme, String hostname, int port, boolean punycoded) {
        this.scheme = scheme;
        this.hostname = hostname;
        this.port = port;
        this.punycoded = punycoded;

        www = hostname.startsWith(WWW);
    }

    public String getScheme() {
        return scheme;
    }

    public String getHostname() {
        return hostname;
    }

    public int getPort() {
        return port;
    }

    public boolean isWWW() {
        return www;
    }

    public boolean equalsIgnoreWWW(Hostname other) {
        String thisHostname;
        String otherHostname;
        if (!punycoded) {
            thisHostname = IDN.toASCII(this.hostname);
        } else {
            thisHostname = this.hostname;
        }

        if(!other.punycoded) {
            otherHostname = IDN.toASCII(other.hostname);
        } else {
            otherHostname = other.hostname;
        }

        if (www ^ other.www) {
            return thisHostname.equals(otherHostname);
        }
        if (www) {
            return thisHostname.substring(WWW.length()).equals(otherHostname);
        }
        return thisHostname.equals(otherHostname.substring(WWW.length()));
    }
}
