package ru.yandex.webmaster.common.util;

import org.jetbrains.annotations.NotNull;

/**
 * @author aherman
 */
public class HostnamePart {
    private final Protocol protocol;
    private final String hostnamePart;
    private final boolean isPrefix;
    private final boolean isIDN;

    public HostnamePart(@NotNull Protocol protocol, @NotNull String hostnamePart, boolean isPrefix, boolean isIDN) {
        this.protocol = protocol;
        this.hostnamePart = hostnamePart;
        this.isPrefix = isPrefix;
        this.isIDN = isIDN;
    }

    public Protocol getProtocol() {
        return protocol;
    }

    public String getHostnamePart() {
        return hostnamePart;
    }

    public boolean isPrefix() {
        return isPrefix;
    }

    public boolean isIDN() {
        return isIDN;
    }

    public static enum Protocol {
        HTTP,
        HTTPS
    }
}
