package ru.yandex.webmaster.common.util.functional;

/**
 * @author avhaliullin
 */
public interface Bijection<L, R> {
    R leftToRight(L l);

    L rightToLeft(R r);

    static <T> Bijection<T, T> identity() {
        return new Bijection<T, T>() {
            @Override
            public T leftToRight(T t) {
                return t;
            }

            @Override
            public T rightToLeft(T t) {
                return t;
            }
        };
    }

    static <L, R> Bijection<L, R> create(Functions.F1<L, R> l2r, Functions.F1<R, L> r2l) {
        return new Bijection<L, R>() {
            @Override
            public R leftToRight(L l) {
                return l2r.apply(l);
            }

            @Override
            public L rightToLeft(R r) {
                return r2l.apply(r);
            }
        };
    }
}
