package ru.yandex.webmaster.common.util.functional;

import java.util.function.Consumer;

/**
 * @author avhaliullin
 */
@FunctionalInterface
public interface ThrowingConsumer<T, E extends Exception> {
    void accept(T item) throws E;

    static <T, E extends Exception> Consumer<T> rethrowingUnchecked(ThrowingConsumer<T, E> c) {
        return v -> {
            try {
                c.accept(v);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}
