package ru.yandex.webmaster.common.xml.limits;

import java.util.Collections;
import java.util.Comparator;

import org.springframework.util.comparator.CompoundComparator;

import ru.yandex.wmconsole.data.HostLimitsSortTypeEnum;
import ru.yandex.wmconsole.data.info.HostsReportLimitsInfo;

/**
 * User: azakharov
 * Date: 23.09.13
 * Time: 19:44
 */
// TODO: clean code
public class HostLimitComparator /*implements Comparator<HostsReportLimitsInfo.HostLimitInfo>*/ {

/*
    private final OrderByClause orderByClause;

    public HostLimitComparator(OrderByClause orderByClause) {
        this.orderByClause = orderByClause;
    }
*/

/*
    @Override
    public int compare(HostsReportLimitsInfo.HostLimitInfo o1, HostsReportLimitsInfo.HostLimitInfo o2) {
        final int res;

        if (HostLimitsSortTypeEnum.SORT_BY_HOSTNAME.getFieldName().equals(orderByClause.getColumnName())) {

            // sort hosts using hostname
            res = o1.getHostName().compareToIgnoreCase(o2.getHostName());
        } else if (HostLimitsSortTypeEnum.SORT_BY_LIMIT.getFieldName().equals(orderByClause.getColumnName())) {

            // sort by host limit
            res = o1.getLimit().compareTo(o2.getLimit());
        } else {
            // assume default sort

            boolean z1 = o1.getLimit().equals(0L);
            boolean z2 = o2.getLimit().equals(0L);

            if (z1 ^ z2) {
                // one of hosts has nonzero limit, another one has zero limit

                // hosts with zero limit must be in the tail of host list
                res = -o1.getLimit().compareTo(o2.getLimit());
            } else {
                // both hosts have zero limits or both hosts have nonzero limit

                // sort hosts using hostname
                res = o1.getHostName().compareToIgnoreCase(o2.getHostName());
            }
        }

        if (!orderByClause.isAscending()) {
            return -res;
        } else {
            return res;
        }
    }
*/

    public static Comparator<HostsReportLimitsInfo.HostLimitInfo> getComparator(HostLimitsSortTypeEnum sort, boolean ascending) {
        Comparator<HostsReportLimitsInfo.HostLimitInfo> result;

        switch(sort) {
            case SORT_BY_HOSTNAME:
                result = BY_HOSTNAME;
                break;

            case SORT_BY_LIMIT:
                result = BY_LIMIT;
                break;

            default:
                result = DEFAULT;
        }
        if (!ascending) {
            result = Collections.reverseOrder(result);
        }
        return result;
    }

    static Comparator<HostsReportLimitsInfo.HostLimitInfo> BY_HOSTNAME = new Comparator<HostsReportLimitsInfo.HostLimitInfo>() {
        @Override
        public int compare(HostsReportLimitsInfo.HostLimitInfo o1, HostsReportLimitsInfo.HostLimitInfo o2) {
            return o1.getHostName().compareToIgnoreCase(o2.getHostName());
        }
    };

    static Comparator<HostsReportLimitsInfo.HostLimitInfo> BY_LIMIT = new Comparator<HostsReportLimitsInfo.HostLimitInfo>() {
        @Override
        public int compare(HostsReportLimitsInfo.HostLimitInfo o1, HostsReportLimitsInfo.HostLimitInfo o2) {
            return o1.getLimit().compareTo(o2.getLimit());
        }
    };

    static Comparator<HostsReportLimitsInfo.HostLimitInfo> DEFAULT =
            new CompoundComparator<>(Collections.reverseOrder(BY_LIMIT), BY_HOSTNAME);
}
