package ru.yandex.webmaster3;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.collections.Cu;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractExternalHttpService;

import java.util.Map;

/**
 * User: azakharov
 * Date: 07.11.14
 * Time: 20:39
 */
public class NewWebmasterHttpService extends AbstractExternalHttpService implements INewWebmasterHttpService {

    private int timeout = 5000;

    //TODO: how to process mirrors
    @Override
    public void addHost(long userId, BriefHostInfo hostInfo) throws InternalException {
        internalAddHost(userId, hostInfo.getName(), false);
    }

    @Override
    public void removeHost(long userId, BriefHostInfo hostInfo) throws InternalException {
        String webmasterHostId = briefHostInfoToWebmaster3HostId(hostInfo);
        doRemoveHost(userId, webmasterHostId);
    }

    private static String briefHostInfoToWebmaster3HostId(BriefHostInfo briefHostInfo) {
        boolean isHttps = briefHostInfo.getName().startsWith("https://");
        int portIndex;
        final String scheme;
        String hostName;
        if (isHttps) {
            hostName = briefHostInfo.getName().substring("https://".length());
            scheme = "https";
        } else {
            hostName = briefHostInfo.getName();
            scheme = "http";
        }
        portIndex = hostName.indexOf(':');
        final int port;
        if (portIndex == -1) {
            port = isHttps ? 443 : 80;
        } else {
            port = Integer.valueOf(hostName.substring(portIndex + 1));
            hostName = hostName.substring(0, portIndex);
        }
        return scheme + ":" + hostName.toLowerCase() + ":" + port;
    }

    private void doRemoveHost(long userId, String webmasterHostId) throws InternalException {
        final String userIdParam = "userId";
        final String hostUrlParam = "hostId";
        final Map<String, Object> params = Cu.pairsToMap(
                Cf.pair(userIdParam, (Object)String.valueOf(userId)),
                Cf.pair(hostUrlParam, (Object)webmasterHostId));
        httpGetResponse("/old-webmaster/api/deleteHost.json", params, timeout, true);
    }

    @Override
    public void verifyHost(long userId, BriefHostInfo hostInfo) throws InternalException {
        internalAddHost(userId, hostInfo.getName(), true);
    }

    @Override
    public void cancelVerification(long userId, BriefHostInfo hostInfo) throws InternalException {
        internalAddHost(userId, hostInfo.getName(), false);
    }

    private void internalAddHost(long userId, String hostUrl, boolean isVerified) throws InternalException {
        final String userIdParam = "userId";
        final String hostUrlParam = "hostUrl";
        final String isVerifiedParam = "verified";
        final Map<String, Object> params = Cu.pairsToMap(
                Cf.pair(userIdParam, (Object)String.valueOf(userId)),
                Cf.pair(hostUrlParam, (Object)hostUrl.toLowerCase()),
                Cf.pair(isVerifiedParam, (Object)Boolean.valueOf(isVerified)));
        httpGetResponse("/old-webmaster/api/addHost.json", params, timeout, true);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}
