package ru.yandex.webmaster3;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster.common.host.HostEventService;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * User: azakharov
 * Date: 14.11.14
 * Time: 20:03
 */
public class SafeNewWebmasterHttpService implements INewWebmasterHttpService {

    private NewWebmasterHttpService simpleNewWebmasterHttpService;
    private HostEventService hostEventService;

    @Override
    public void addHost(long userId, BriefHostInfo hostInfo) throws InternalException {
        try {
            simpleNewWebmasterHttpService.addHost(userId, hostInfo);
        } catch (InternalException e) {
            hostEventService.userHostRetryEvent(hostInfo.getId(), userId);
        }
    }

    @Override
    public void removeHost(long userId, BriefHostInfo hostInfo) throws InternalException {
        try {
            simpleNewWebmasterHttpService.removeHost(userId, hostInfo);
        } catch (InternalException e) {
            hostEventService.userHostRetryEvent(hostInfo.getId(), userId);
        }
    }

    @Override
    public void verifyHost(long userId, BriefHostInfo hostInfo) throws InternalException {
        try {
            simpleNewWebmasterHttpService.verifyHost(userId, hostInfo);
        } catch (InternalException e) {
            hostEventService.userHostRetryEvent(hostInfo.getId(), userId);
        }
    }

    @Override
    public void cancelVerification(long userId, BriefHostInfo hostInfo) throws InternalException {
        try {
            simpleNewWebmasterHttpService.cancelVerification(userId, hostInfo);
        } catch (InternalException e) {
            hostEventService.userHostRetryEvent(hostInfo.getId(), userId);
        }
    }

    @Required
    public void setSimpleNewWebmasterHttpService(NewWebmasterHttpService simpleNewWebmasterHttpService) {
        this.simpleNewWebmasterHttpService = simpleNewWebmasterHttpService;
    }

    @Required
    public void setHostEventService(HostEventService hostEventService) {
        this.hostEventService = hostEventService;
    }
}
