package ru.yandex.wmconsole.data;

import java.net.URI;
import java.net.URL;

import org.jetbrains.annotations.NotNull;

/**
 * @author aherman
 */
public class AddUrlRequest {
    private final URL url;
    private final String userIp;
    private final String frontendIp;

    private final Long userId;
    private final String yandexUid;

    private boolean allowed = true;
    private URI resultingUri;

    public AddUrlRequest(@NotNull URL url, String frontendIp, Long userId, String userIp, String yandexUid) {
        this.url = url;
        this.frontendIp = frontendIp;
        this.userId = userId;
        this.userIp = userIp;
        this.yandexUid = yandexUid;
    }

    public URL getUrl() {
        return url;
    }

    public String getFrontendIp() {
        return frontendIp;
    }

    public Long getUserId() {
        return userId;
    }

    public String getUserIp() {
        return userIp;
    }

    public String getYandexUid() {
        return yandexUid;
    }

    public boolean isAllowed() {
        return allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public URI getResultingUri() {
        return resultingUri;
    }

    public void setResultingUri(URI resultingUri) {
        this.resultingUri = resultingUri;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AddUrlRequest that = (AddUrlRequest) o;

        if (frontendIp != null ? !frontendIp.equals(that.frontendIp) : that.frontendIp != null) {
            return false;
        }
        if (!url.toString().equals(that.url.toString())) {
            return false;
        }
        if (userId != null ? !userId.equals(that.userId) : that.userId != null) {
            return false;
        }
        if (userIp != null ? !userIp.equals(that.userIp) : that.userIp != null) {
            return false;
        }
        if (yandexUid != null ? !yandexUid.equals(that.yandexUid) : that.yandexUid != null) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result = url.toString().hashCode();
        result = 31 * result + (frontendIp != null ? frontendIp.hashCode() : 0);
        result = 31 * result + (userId != null ? userId.hashCode() : 0);
        result = 31 * result + (userIp != null ? userIp.hashCode() : 0);
        result = 31 * result + (yandexUid != null ? yandexUid.hashCode() : 0);
        return result;
    }
}
