package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * Sitemap error enumeration.
 *
 * @author ailyin
 */
public enum AvailableEnum implements IntEnum {
    OPTION_DISABLED(-1),
    NOT_READY(0),
    OLD(1),
    NEW(2),
    ;

    private int value;

    private AvailableEnum(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<AvailableEnum> R = IntEnumResolver.r(AvailableEnum.class);
}
