package ru.yandex.wmconsole.data;

import org.joda.time.DateTime;

/**
 * @author aherman
 */
public class BlockedUserInfo {
    private final long userId;
    private final long blockedByUserId;
    private final UserBlockReason blockReason;
    private final DateTime blockDate;

    public BlockedUserInfo(long userId, long blockedByUserId, UserBlockReason blockReason, DateTime blockDate) {
        this.userId = userId;
        this.blockedByUserId = blockedByUserId;
        this.blockReason = blockReason;
        this.blockDate = blockDate;
    }

    public long getUserId() {
        return userId;
    }

    public long getBlockedByUserId() {
        return blockedByUserId;
    }

    public UserBlockReason getBlockReason() {
        return blockReason;
    }

    public DateTime getBlockDate() {
        return blockDate;
    }
}
