package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

public enum DisplayNameModerationStateEnum implements IntEnum {
    IN_PROGRESS(1),
    ACCEPTED(2),
    REFUSED(3),
    MODERATOR_ISSUED(4),
    ;

    private final int id;

    DisplayNameModerationStateEnum(int id) {
        this.id = id;
    }

    public int getId() {
        return id;
    }

    @Override
    public int value() {
        return id;
    }

    public static final IntEnumResolver<DisplayNameModerationStateEnum> R = IntEnumResolver.r(DisplayNameModerationStateEnum.class);
}
