package ru.yandex.wmconsole.data;

import org.jetbrains.annotations.Nullable;
import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * User: baton
 * Date: 28.03.2007
 * Time: 18:45:21
 */
public enum HostInfoStatusEnum implements IntEnum {
    WAITING(0, true),          // добавлен в очередь на индексирование
    FINISHED(13, true),        // ваш сайт скоро появится в индексе
    FILTERED(1, true),         // не используется
    ROBOTS_TXT(2),             // при добавлении сайта главная страница была исключена в robots.txt
    INTERNAL_ERROR(4, true),
    // статусы пенальти
    CONNECTION_FAILED(3),
    DNS_ERROR(5),
    DISALLOW(6),
    DISALLOW_YANDEX(14),
    WILL_CONNECTION_FAILED(7),
    WILL_DNS_ERROR(8),
    WILL_DISALLOW(9),
    WARN_CONNECTION_FAILED(10),
    WARN_DNS_ERROR(11),
    WARN_DISALLOW(12)
    ;

    private final int value;
    private final boolean internal;

    HostInfoStatusEnum(int value) {
        this(value, false);
    }

    HostInfoStatusEnum(int value, boolean internal) {
        this.value = value;
        this.internal = internal;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isInternal() {
        return internal;
    }


    public String getShownName() {
        return name();
    }

    public static final IntEnumResolver<HostInfoStatusEnum> R = IntEnumResolver.r(HostInfoStatusEnum.class);

    public static boolean isWillStatus(@Nullable HostInfoStatusEnum status) {
        if (status == null) {
            return false;
        }
        switch(status) {
            case WILL_CONNECTION_FAILED:
            case WILL_DISALLOW:
            case WILL_DNS_ERROR:
                return true;
        }
        return false;
    }

    public static boolean isWarnStatus(@Nullable HostInfoStatusEnum status) {
        if (status == null) {
            return false;
        }
        switch(status) {
            case WARN_CONNECTION_FAILED:
            case WARN_DISALLOW:
            case WARN_DNS_ERROR:
                return true;
        }
        return false;
    }

    public static boolean isPenaltyStatus(@Nullable HostInfoStatusEnum status) {
        if (status == null) {
            return false;
        }
        switch (status) {
            case CONNECTION_FAILED:
            case DISALLOW:
            case DNS_ERROR:
            case WILL_CONNECTION_FAILED:
            case WILL_DISALLOW:
            case WILL_DNS_ERROR:
            case WARN_CONNECTION_FAILED:
            case WARN_DISALLOW:
            case WARN_DNS_ERROR:
                return true;
        }
        return false;
    }
}
