package ru.yandex.wmconsole.data;

/**
 * User: azakharov
 * Date: 14.05.13
 * Time: 16:27
 */
public enum HostLimitsSortTypeEnum {
    /**
     * Default sort is sort by host name with nonzero limit then by host name with zero limit
     */
    DEFAULT("default"),

    /**
     * Sort by hostname, ignoring limit
     */
    SORT_BY_HOSTNAME("host-name"),

    /**
     * Sort by limit
     */
    SORT_BY_LIMIT("host-limit");


    private final String fieldName;

    private HostLimitsSortTypeEnum(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return fieldName;
    }
}
