package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author baton
 */
public enum HostRegionChangeRequestStateEnum implements IntEnum {
    VERIFIED(1, true, true),
    WAITING(2, false, false),
    DENIED(3, false, true),
    DELAYED(4, false, false),
    MODERATOR_ISSUED(5, true, false),
    BANNED(6, false, true);

    private final int value;
    private final boolean verifiedState;
    private final boolean canResolveToThisState;

    HostRegionChangeRequestStateEnum(int value, boolean verifiedState, boolean canResolveToThisState) {
        this.value = value;
        this.verifiedState = verifiedState;
        this.canResolveToThisState = canResolveToThisState;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isVerifiedState() {
        return verifiedState;
    }

    public boolean canResolveToThisState() {
        return canResolveToThisState;
    }

    public static final IntEnumResolver<HostRegionChangeRequestStateEnum> R = IntEnumResolver.r(HostRegionChangeRequestStateEnum.class);
}
