package ru.yandex.wmconsole.data;

import org.joda.time.DateTime;

/**
 * @author aherman
 */
public class HostRobotDbInfo {
    private final UpdateStateEnum state;
    private final int urls;
    private final int docs;
    private final DateTime updatedOn;
    private final DateTime lastAccess;
    private final int shownErrors;
    private final int allErrors;
    private final Integer indexCount;
    private final Integer bannedCount;
    private final int internalLinksCount;
    private final Integer linksCount;
    private final int lastLoaderTime;
    private final int urlTrends;
    private final int indexCountTrends;
    private final int ticTrend;
    private final int linksCountTrend;
    private final boolean htarcInIndex;
    private final boolean prevInIndex;

    public HostRobotDbInfo(UpdateStateEnum state, int urls, int docs, DateTime updatedOn, DateTime lastAccess,
            int shownErrors, int allErrors, Integer indexCount, Integer bannedCount, int internalLinksCount, Integer linksCount, int lastLoaderTime,
            int urlTrends, int indexCountTrends, int ticTrend, int linksCountTrend, boolean htarcInIndex,
            boolean prevInIndex)
    {
        this.state = state;
        this.urls = urls;
        this.docs = docs;
        this.updatedOn = updatedOn;
        this.lastAccess = lastAccess;
        this.shownErrors = shownErrors;
        this.allErrors = allErrors;
        this.indexCount = indexCount;
        this.bannedCount = bannedCount;
        this.internalLinksCount = internalLinksCount;
        this.linksCount = linksCount;
        this.lastLoaderTime = lastLoaderTime;
        this.urlTrends = urlTrends;
        this.indexCountTrends = indexCountTrends;
        this.ticTrend = ticTrend;
        this.linksCountTrend = linksCountTrend;
        this.htarcInIndex = htarcInIndex;
        this.prevInIndex = prevInIndex;
    }

    public UpdateStateEnum getState() {
        return state;
    }

    public int getUrls() {
        return urls;
    }

    public int getDocs() {
        return docs;
    }

    public DateTime getUpdatedOn() {
        return updatedOn;
    }

    public DateTime getLastAccess() {
        return lastAccess;
    }

    public int getShownErrors() {
        return shownErrors;
    }

    public int getAllErrors() {
        return allErrors;
    }

    public Integer getIndexCount() {
        return indexCount;
    }

    public int getInternalLinksCount() {
        return internalLinksCount;
    }

    public Integer getLinksCount() {
        return linksCount;
    }

    public int getLastLoaderTime() {
        return lastLoaderTime;
    }

    public int getUrlTrends() {
        return urlTrends;
    }

    public int getIndexCountTrends() {
        return indexCountTrends;
    }

    public int getTicTrend() {
        return ticTrend;
    }

    public int getLinksCountTrend() {
        return linksCountTrend;
    }

    public boolean isHtarcInIndex() {
        return htarcInIndex;
    }

    public boolean isPrevInIndex() {
        return prevInIndex;
    }

    public Integer getBannedCount() {
        return bannedCount;
    }
}
