package ru.yandex.wmconsole.data;

import java.util.LinkedHashSet;
import java.util.Set;

/**
 * User: azakharov
 * Date: 05.02.13
 * Time: 13:41
 */
public enum IndexingEntityEnum {
    ROBOTDB_INFO_URLS(          "robotdb_info_urls",        true, "urls",           false,  false),
    ROBOTDB_INFO_INDEX_COUNT(   "robotdb_info_index_count", true, "index_count",    false,  false),
    URL_TREES_URLS(             "url_trees_urls",           true, "urls",           true,   true),
    URL_TREES_INDEX_COUNT(      "url_trees_index_count",    true, "index_count",    true,   true),
    LINKS_COUNT(                "links_count",              false, "links_count",   false,  true),
    TCY(                        "tcy",                      false, "tcy",           false,  false);

    // имя таблицы без префикса tbl_trend_
    private String name;
    // кто вычисляет тренд
    private boolean fromLoader;
    // название показателя
    private String column;
    // относится к tbl_url_trees.node_id
    private boolean entityForNode;
    // относится к поисковому шарду
    private boolean entityForSearchShard;

    private IndexingEntityEnum(String name, boolean fromLoader, String column, boolean entityForNode, boolean entityForSearchShard) {
        this.name = name;
        this.fromLoader = fromLoader;
        this.column = column;
        this.entityForNode = entityForNode;
        this.entityForSearchShard = entityForSearchShard;
    }

    /**
     * Название таблицы без префикса tbl_trend_
     *
     * @return
     */
    public String getName() {
        return name;
    }

    /**
     * Формируется история лоадером или периодиком
     *
     * @return
     */
    public boolean isFromLoader() {
        return fromLoader;
    }

    /**
     * Название поля для значения показателя истории
     *
     * @return
     */
    public String getColumn() {
        return column;
    }

    /**
     * Показатель индексирования относится к узлу дерева в структуре сайта
     *
     * @return
     */
    public boolean isEntityForNode() {
        return entityForNode;
    }

    /**
     * Показатель индексирования может различаться для различных поисковых шардов и хранится для каждого шарда
     *
     * @return true, если для шардов
     */
    public boolean isEntityForSearchShard() {
        return entityForSearchShard;
    }

    /**
     * Показатели, которые хранятся в таблице с колонкой host_id.
     * Для них копируется история при переклейке зеркал.
     *
     * @return множество показателей индексирования
     */
    public static Set<IndexingEntityEnum> getEntitiesForHost() {
        Set<IndexingEntityEnum> entities = new LinkedHashSet<IndexingEntityEnum>();
        entities.add(ROBOTDB_INFO_URLS);
        entities.add(ROBOTDB_INFO_INDEX_COUNT);
        entities.add(LINKS_COUNT);
        entities.add(TCY);
        return entities;
    }
}
