package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * Язык локализации
 *
 * User: azakharov
 * Date: 17.05.12
 * Time: 17:43
 */
public enum LanguageEnum implements IntEnum {
    RU("ru", 0),
    UK("uk", 1),
    EN("en", 2),
    TR("tr", 3);

    public static final LanguageEnum DEFAULT_EMAIL_LANGUAGE = RU;

    private String name;
    private int id;

    private LanguageEnum(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public int getId() {
        return id;
    }

    @Override
    public int value() {
        return id;
    }

    public static LanguageEnum fromString(String value) {
        for (LanguageEnum lang : values()) {
            if (lang.name.equalsIgnoreCase(value)) {
                return lang;
            }
        }

        return null;
    }

    public static final IntEnumResolver<LanguageEnum> R = IntEnumResolver.r(LanguageEnum.class);
}
