package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * Describles allowed shown urls time intervals since now
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public enum LastDaysFilterEnum implements IntEnum {
    /** Internal mail of service, default channel for every user */
    ONE_WEEK(7),

    /** SMS messages */
    TWO_WEEKS(14),

    /** EMAIL messages */
    THREE_WEEKS(21),
    ;

    private int value;

    private LastDaysFilterEnum(int value) {
        this.value = value;
    }


    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public Integer getIntegerValue() {
        return value;
    }

    public static final IntEnumResolver<LastDaysFilterEnum> R = IntEnumResolver.r(LastDaysFilterEnum.class);
}
