package ru.yandex.wmconsole.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author avhaliullin
 */
public enum MainMirrorRequestStateEnum implements IntEnum {
    IN_PROGRESS(0),
    ACCEPTED(1),
    DECLINED(2),
    RECHECK_DECLINED(3),
    RECHECK_IN_PROGRESS(4),
    ;

    private final int value;
    private static final List<Integer> forUpload;
    private static final List<Integer> waiting;

    static {
        List<Integer> tmp = new ArrayList<Integer>();
        tmp.add(IN_PROGRESS.getValue());
        tmp.add(ACCEPTED.getValue());
        tmp.add(RECHECK_IN_PROGRESS.getValue());
        forUpload = Collections.unmodifiableList(tmp);

        tmp = new ArrayList<Integer>();
        tmp.add(IN_PROGRESS.getValue());
        tmp.add(RECHECK_IN_PROGRESS.getValue());
        waiting = Collections.unmodifiableList(tmp);
    }

    MainMirrorRequestStateEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public static List<Integer> getWaitingStates() {
        return waiting;
    }

    public static List<Integer> getStatesForUpload() {
        return forUpload;
    }

    public static final IntEnumResolver<MainMirrorRequestStateEnum> R = IntEnumResolver.r(MainMirrorRequestStateEnum.class);
}
