package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author avhaliullin
 */
public enum MainMirrorStateEnum implements IntEnum {
    DEFAULT(0),
    WITH_WWW(1),
    WITHOUT_WWW(2),
    ;

    private final int value;

    MainMirrorStateEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<MainMirrorStateEnum> R = IntEnumResolver.r(MainMirrorStateEnum.class);
}
