package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * Describes the channel notifications are send by
 *
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public enum NotificationChannelEnum implements IntEnum {
    MESSAGE(0),     // internal mail of service, default channel for every user
    SMS(1),          // sms messages
    EMAIL(2),        // email messages
    INTERNAL(3),    // internal service notifications
    ;

    private final int value;

    private NotificationChannelEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<NotificationChannelEnum> R = IntEnumResolver.r(NotificationChannelEnum.class);
}
