package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * Describes types of notification issues
 *
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public enum NotificationTypeEnum implements IntEnum {
    VERIFICATION_FAILED(0, 6), // used when host verification has failed after last verification
    GLOBAL_MESSAGE(1, 0),     // custom mass message from service for all users
    PERSONAL_MESSAGE(2, 0),   // personal message for exact user from service
    SEARCH_UPDATE(3, 10),      // mass message from service for all users about search engine update
    SPAM(4, 3),                 // by host message about spam at some page
    ERRORS_GROW(5, 5),        // big errors number grow for site, personal
    MIRROR_CHANGED(6, 11),          // main mirrow changed, need to send notification to user                                   !
    XSS(7, 2),                   // XSS attack, by host message about attack - equivalent to SPAM notification
    VIRUS(8, 0),                 // some pages are infected
    HEALED(9, 0),               // virus was healed
    CHECK_INFECTED(10, 8),     // recheck was requested and virus is still present
    CHECK_CURED(11, 9),        // DEPRECATED recheck was requested and virus was removed
    CLOAKING(12, 1),            // hidden text on the page
    VIRUS_DOMAIN(13, 0),       // some pages are infected notification for domain owner (www.lenta.ru for realty.lenta.ru)
    HOST_UNAVAILABLE(14, 11),   // site is not responding                                                                       !
    HOST_OWNERS(15, 11),        // custom message for all host owners                                                           !
    MAIN_MIRROR(16, 4),        // main mirror change event                                                                     !
    HOST_VERIFIED(17, 7),      // Your host verified for user
    DELEGATION(18, 7),         // rights where delegated to user
    HOST_VERIFIED_FOR_ME(19, 7),//Host verified for me
    SERVICE_MESSAGE(20, 11),    // Used only when viewing messages for backward compatibility (Real value is >1023).
    VIRUS_FOR_MIRROR(21, 0),    // In order to inform main mirror when virus found for some mirror site
    HOST_STATUS_CHANGED(22, 0), // Host status changed in tbl_penalty_info table (notification from periodic task)
    HOST_STATUS_CONNECTION_FAILED(23, 0),      // notification for user
    HOST_STATUS_DNS_ERROR(24, 0),              // notification for user
    HOST_STATUS_DISALLOW(25, 0),               // notification for user
    HOST_STATUS_WILL_CONNECTION_FAILED(26, 0), // notification for user
    HOST_STATUS_WILL_DNS_ERROR(27, 0),         // notification for user
    HOST_STATUS_WILL_DISALLOW(28, 0),          // notification for user
    HOST_STATUS_WARN_CONNECTION_FAILED(29, 0), // notification for user
    HOST_STATUS_WARN_DNS_ERROR(30, 0),         // notification for user
    HOST_STATUS_WARN_DISALLOW(31, 0),          // notification for user
    DOORWAY(32, 0),
    MIRROR_GROUPS(33, 4),        // main mirror change event for one or more mirror groups
    NEW_BAD_SOFTWARE(34, 0),     // bad software distribution detected for host
    CLEAR_BAD_SOFTWARE(35, 0);   // host stops bad software distribution

    public static final int MAX_VALUE = 1023;

    private final int value;
    //Highest priority is 0;
    private final int priority;

    private NotificationTypeEnum(int value, int priority) {
        this.value = value;
        this.priority = priority;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public int getPriority() {
        return priority;
    }

    public static final IntEnumResolver<NotificationTypeEnum> R = IntEnumResolver.r(NotificationTypeEnum.class);
}
