package ru.yandex.wmconsole.data;

import java.util.Collection;
import java.util.Map;

/**
 * User: azakharov
 * Date: 14.12.12
 * Time: 16:50
 */
public class ServerResponseInfo {
    private final Integer httpCode;
    private final String httpCodeName;
    private final Map<String, Collection<String>> headers;
    private final String ip;
    private final Long responseTime;
    private final String location;
    private double size;
    private String encoding;
    private boolean isText;
    private String body;
    private String sitaRequestJson;
    private String sitaResponseJson;

    Integer yandexHttpCode;

    public ServerResponseInfo(Integer httpCode, String httpCodeName, Map<String, Collection<String>> headers, String ip, Long responseTime, String location, Integer xYandexHttpCode) {
        this.httpCode = httpCode;
        this.httpCodeName = httpCodeName;
        this.headers = headers;
        this.ip = ip;
        this.responseTime = responseTime;
        this.location = location;
        this.yandexHttpCode = xYandexHttpCode;
    }

    public Integer getHttpCode() {
        return httpCode;
    }

    public String getHttpCodeName() {
        return httpCodeName;
    }

    public Map<String, Collection<String>> getHeaders() {
        return headers;
    }

    public String getIp() {
        return ip;
    }

    public Long getResponseTime() {
        return responseTime;
    }

    public String getLocation() {
        return location;
    }

    public double getSize() {
        return size;
    }

    public String getEncoding() {
        return encoding;
    }

    public boolean isText() {
        return isText;
    }

    public String getBody() {
        return body;
    }

    public Integer getYandexHttpCode() {
        return yandexHttpCode;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setText(boolean text) {
        isText = text;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSitaRequestJson() {
        return sitaRequestJson;
    }

    public void setSitaRequestJson(String sitaRequestJson) {
        this.sitaRequestJson = sitaRequestJson;
    }

    public String getSitaResponseJson() {
        return sitaResponseJson;
    }

    public void setSitaResponseJson(String sitaResponseJson) {
        this.sitaResponseJson = sitaResponseJson;
    }
}
