package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * External services enumeration.
 *
 * @author ailyin
 */
public enum ServiceEnum implements IntEnum {
    RECIPES(1, false),
    MARKET(2, false),
    RABOTA(3, false),
    SLOVARI(4, false),
    ADDRESSES(5, true), // for future use
    REFERAT(6, false),
    USLUGI(7, false),
    REALTY(8, false),
    OTZYVI(9, false),
    AUTO(10, false),
    ORIGINALS(11, false),
    ISLANDS(12, false),
    ;

    private final int value;
    private final boolean enabledByDefault;

    private ServiceEnum(int value, boolean enabledByDefault) {
        this.value = value;
        this.enabledByDefault = enabledByDefault;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isEnabledByDefault() {
        return enabledByDefault;
    }

    public static final IntEnumResolver<ServiceEnum> R = IntEnumResolver.r(ServiceEnum.class);
}
