package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author avhaliullin
 */
public enum SpiderRequestResultEnum implements IntEnum {
    FETCH(0, "3"),
    DNS_ERROR(1, "4, 5"),
    CONNECTION_FAILED(2, "1010");

    private final String filter;
    private final int value;

    SpiderRequestResultEnum(int value, String filter) {
        this.value = value;
        this.filter = filter;
    }

    public static SpiderRequestResultEnum getByCode(int code) {
        if (code == 4 || code == 5) {
            return DNS_ERROR;
        }
        if (code == 3) {
            return FETCH;
        }
        if (code == 1010) {
            return CONNECTION_FAILED;
        }
        return null;
    }

    public String getFilter() {
        return filter;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<SpiderRequestResultEnum> R = IntEnumResolver.r(SpiderRequestResultEnum.class);
}
