package ru.yandex.wmconsole.data;


import java.util.Comparator;

import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.common.util.db.OrderByClause;

/**
 * User: baton
 * Date: 15.08.2007
 * Time: 16:46:03
 */
public class TreeNodeChildrenComparator {
    private static final Logger log = LoggerFactory.getLogger(TreeNodeChildrenComparator.class);

    public static Comparator<Node> getComparator(OrderByClause order) {
        String columnName = order.getColumnName();
        boolean ascending = "asc".equals(order.getMode());
        // TODO: use appropriate order enum instead of general column name
        if ("name".equals(columnName)) {
            return new ByNameComparator(ascending);
        } else if ("index-count".equals(columnName)) {
            return new ByIndexCountComparator(ascending);
        } else if ("urls".equals(columnName) || "count".equals(columnName)) {
            return new ByUrlsComparator(ascending);
        }

        // Default comparator
        return new ByNameComparator(ascending);
    }

    private static class ByNameComparator implements Comparator<Node> {
        private final boolean ascending;

        private ByNameComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(Node node1, Node node2) {
            return node1.getInfo().getName().compareTo(node2.getInfo().getName()) * (ascending ? 1 : -1);
        }
    }

    private static class ByIndexCountComparator implements Comparator<Node> {
        private final boolean ascending;

        private ByIndexCountComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(Node node1, Node node2) {
            return compareLong(node1.getInfo().getIndexCount(), node2.getInfo().getIndexCount(), ascending);
        }
    }

    private static class ByUrlsComparator implements Comparator<Node> {
        private final boolean ascending;

        private ByUrlsComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(Node node1, Node node2) {
            return compareLong(node1.getInfo().getUrlsInSubtree(), node2.getInfo().getUrlsInSubtree(), ascending);
        }
    }

    private static int compareLong(@Nullable Long l1, @Nullable Long l2, boolean ascending) {
        int order = -1;

        if (l1 != null) {
            if (l2 == null) {
                // L1 != null, L2 == null
                order = 1;
            } else {
                // L1 != null, L2 != null, compare them
                order = l1.compareTo(l2);
            }
        } else {
            if (l2 == null) {
                // L1 == null, L2 == null
                return 0;
            }
            // L1 == null, L2 != null, order = -1 by default
        }

        return ascending ? order : -order;
    }
}
