package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * User: baton
 * Date: 28.03.2007
 * Time: 18:45:21
 */
public enum UpdateStateEnum implements IntEnum {
    WAITING(0),
    UPDATED(1),
    IN_PROGRESS(2),
    NEW(3),
    FIRST_IN_PROGRESS(4),
    ;

    private int value;

    UpdateStateEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<UpdateStateEnum> R = IntEnumResolver.r(UpdateStateEnum.class);
}
