package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum UserBlockReason implements IntEnum {
    UNKNOWN(0),

    AUTOMATED_REQUESTS(1),
    BLOCK_BY_SUPPORT(2),

    UNVERIFIED_SITES_SPAM(3),
    AUTOMATICALLY_ADDED_SITES_SPAM(4),
    ;

    private UserBlockReason(int value) {
        this.value = value;
    }

    private final int value;

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<UserBlockReason> R = IntEnumResolver.r(UserBlockReason.class);
}
