package ru.yandex.wmconsole.data;

import ru.yandex.wmconsole.data.info.NotificationOptionInfo;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class UserNotificationOptions {
    private final Long userId;
    private final Set<NotificationOptionInfo> notificationOptions = new HashSet<NotificationOptionInfo>();

    private static final Set<NotificationOptionInfo> ALWAYS_ON_OPTIONS =
            Collections.unmodifiableSet(new HashSet<NotificationOptionInfo>() {
                {
                    add(new NotificationOptionInfo(NotificationTypeEnum.GLOBAL_MESSAGE, NotificationChannelEnum.MESSAGE));
                    add(new NotificationOptionInfo(NotificationTypeEnum.PERSONAL_MESSAGE, NotificationChannelEnum.MESSAGE));
                }
            });

    public UserNotificationOptions(Long userId) {
        this.userId = userId;
        forceAlwaysOnOptions();
    }

    private void forceAlwaysOnOptions() {
        for (NotificationOptionInfo option : ALWAYS_ON_OPTIONS) {
            addNotificationOption(option);
        }
    }

    public void addNotificationOption(NotificationTypeEnum notificationType, NotificationChannelEnum notificationChannel) {
        notificationOptions.add(new NotificationOptionInfo(notificationType, notificationChannel));
    }

    public void addNotificationOption(NotificationOptionInfo notificationOption) {
        notificationOptions.add(notificationOption);
    }

    public void addNotificationOption(int notificationType, NotificationChannelEnum notificationChannel) {
        notificationOptions.add(new NotificationOptionInfo(notificationType, notificationChannel));
    }

    public Long getUserId() {
        return userId;
    }

    public Set<NotificationOptionInfo> getNotificationOptions() {
        return Collections.unmodifiableSet(notificationOptions);
    }

    public boolean containsOption(Integer notificationType, NotificationChannelEnum notificationChannel) {
        NotificationOptionInfo optionToCheck = new NotificationOptionInfo(notificationType, notificationChannel);
        return notificationOptions.contains(optionToCheck);
    }
}
