package ru.yandex.wmconsole.data;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;
import ru.yandex.wmtools.common.util.SqlUtil;

/**
 * User: baton
 * Date: 28.03.2007
 * Time: 18:45:21
 */
public enum VerificationStateEnum implements IntEnum {
    VERIFIED(1, true, false),
    WAITING(2),
    IN_PROGRESS(3),
    RECHECK_WAITING(12, true, true),
    RECHECK_IN_PROGRESS(13, true, true),

    // NOT VERIFIED REASONS:

    // txt file
    TXT_FILE_NON_ZERO_LENGTH(-1),
    TXT_FILE_IO_EXCEPTION(-2),
    TXT_FILE_METHOD_NOT_APPLICABLE_FOR_HOST(-3),
    TXT_FILE_HTTP_CODE(-4), //  representation of TXT_FILE_IO_EXCEPTION when server returns bad http code

    // html file
    HTML_FILE_WRONG_CONTENT(-11),
    HTML_FILE_IO_EXCEPTION(-12),
    HTML_FILE_PARSER_EXCEPTION(-13),
    HTML_FILE_HTTP_CODE(-14), // representation of HTML_FILE_IO_EXCEPTION when server returns bad http code

    // dns
    DNS_TEXT_PARSE_EXCEPTION(-21),
    DNS_NO_SUCH_ENTRY(-22),
    LONG_DNS_WAITING(-23),

    //Whois
    WHOIS_SERVER_CONNECTION_EXCEPTION(-41),
    WHOIS_EMAIL_NOT_FOUND(-42),
    WHOIS_UNCONFIRMED_EMAIL(-44),

    // meta tag
    META_TAG_VERIFICATION_TAG_NOT_FOUND(-51),
    META_TAG_PARSER_EXCEPTION(-52),
    META_TAG_IO_EXCEPTION(-53),
    META_TAG_HTTP_CODE(-54), // representation of META_TAG_IO_EXCEPTION when server returns bad http code

    // external services
    EXTERNAL_VERIFICATION_USED_ALREADY(-61, true),
    EXTERNAL_VERIFICATION_INTERNAL_ERROR(-62, true),
    EXTERNAL_VERIFICATION_CANCELLED(-63),

    // pdd
    PDD_NOT_APPLICABLE(-71, true),

    //common
    USER_NOT_FOUND_IN_PASSPORT(-80, true),

    // auto verification
    NOT_APPLICABLE_FOR_AUTO_VERIFICATION(-101, true),

    // manual verification
    MANUAL_VERIFICATION_CANCELLED(-111),

    // other
    CANCELLED(-125),
    OTHER_MAIN_MIRROR_CHANGED(-126, true), //todo remove
    UNKNOWN(-127, true),    //todo remove
    NEVER_VERIFIED(-128);

    private final int value;
    private final boolean verified;
    private final boolean internal; //hide from  api clients

    private VerificationStateEnum(int value) {
        this(value, false, false);
    }

    private VerificationStateEnum(int value, boolean internal) {
        this(value, false, internal);
    }

    private VerificationStateEnum(int value, boolean verified, boolean internal) {
        this.value = value;
        this.verified = verified;
        this.internal = internal;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isVerified() {
        return verified;
    }

    public boolean isInternal() {
        return internal;
    }

    public static String getCommaSeparatedListForVerifiedStates() {
        List<Integer> verifiedStates = new ArrayList<Integer>();
        for (VerificationStateEnum value : values()) {
            if (value.isVerified()) {
                verifiedStates.add(value.value());
            }
        }

        return SqlUtil.getCommaSeparatedList(verifiedStates);
    }

    public static EnumSet<VerificationStateEnum> getVerifiedStates() {
        EnumSet<VerificationStateEnum> result = EnumSet.noneOf(VerificationStateEnum.class);
        for (VerificationStateEnum state : values()) {
            if(state.isVerified()) {
                result.add(state);
            }
        }
        return result;
    }

    public static final IntEnumResolver<VerificationStateEnum> R = IntEnumResolver.r(VerificationStateEnum.class);
}
