package ru.yandex.wmconsole.data;

import ru.yandex.wmtools.common.data.IHistoryAction;

public enum WMCHistoryActionEnum implements IHistoryAction {
    SEND((byte) 2),
    ;

    // only values more than 100 can be added!

    private byte value;

    public static WMCHistoryActionEnum getByValue(byte value) {
        for (WMCHistoryActionEnum historyAction : values()) {
            if (value == historyAction.value) {
                return historyAction;
            }
        }

        return null;
    }

    WMCHistoryActionEnum(byte value) {
        this.value = value;
    }

    @Override
    public byte getValue() {
        return value;
    }
}
