package ru.yandex.wmconsole.data;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;
import ru.yandex.wmtools.common.data.IHistoryObjectType;

public enum WMCHistoryObjectTypeEnum implements IHistoryObjectType, IntEnum {
    HOST((byte) 2, false),
    SITEMAP((byte) 3, false),
    GLOBAL_MESSAGE((byte) 4, false),
    PERSONAL_MESSAGE((byte) 5, false),
    HOST_OWNERS_MESSAGE((byte) 6, false);

    // only values more than 100 can be added!

    private byte value;
    private boolean isObjectOfUser;

    WMCHistoryObjectTypeEnum(byte value, boolean isObjectOfUser) {
        this.value = value;
        this.isObjectOfUser = isObjectOfUser;
    }

    @Override
    public byte getValue() {
        return value;
    }


    @Override
    public int value() {
        return value;
    }

    @Override
    public boolean isObjectOfUser() {
        return isObjectOfUser;
    }

    public static final IntEnumResolver<WMCHistoryObjectTypeEnum> R = IntEnumResolver.r(WMCHistoryObjectTypeEnum.class);
}
