package ru.yandex.wmconsole.data.api;

import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;

/**
 * @author ailyin
 */
public enum ApiVerificationState {
    NEVER_VERIFIED,
    WAITING,
    IN_PROGRESS,
    VERIFIED,
    VERIFICATION_FAILED;

    public static ApiVerificationState getByVerifcationStateAndType(VerificationStateEnum state,
            VerificationTypeEnum type) {
        if (VerificationStateEnum.NEVER_VERIFIED.equals(state) || VerificationTypeEnum.CHEAT.equals(type)) {
            return NEVER_VERIFIED;
        } else if (VerificationStateEnum.WAITING.equals(state)) {
            return WAITING;
        } else if (VerificationStateEnum.IN_PROGRESS.equals(state)) {
            return IN_PROGRESS;
        } else if (state.isVerified()) {
            return VERIFIED;
        } else {
            return VERIFICATION_FAILED;
        }
    }
}

