package ru.yandex.wmconsole.data.api;

import ru.yandex.wmconsole.verification.VerificationTypeEnum;

/**
 * @author ailyin
 */
public enum ApiVerificationType {
    TXT_FILE,
    META_TAG,
    AUTO,
    MANUAL,
    PDD,
    HTML_FILE,
    DNS_RECORD,
    DELEGATION,
    WHOIS;

    public static ApiVerificationType getByVerificationType(VerificationTypeEnum verificationType) {
        if (VerificationTypeEnum.CHEAT.equals(verificationType)) {
            throw new IllegalArgumentException("cheat verification type should be hidden from api clients!");
        }

        switch (verificationType) {
            case TXT_FILE:
                return TXT_FILE;
            case META_TAG:
                return META_TAG;
            case AUTO:
                return AUTO;
            case MANUAL:
                return MANUAL;
            case PDD_EXTERNAL:
                return PDD;
            case PDD_AUTO:
                return PDD;
            case HTML_FILE:
                return HTML_FILE;
            case DNS_RECORD:
                return DNS_RECORD;
            case DELEGATION:
                return DELEGATION;
            case WHOIS:
                return WHOIS;

            default:
                throw new IllegalArgumentException("Unsupported type: " + verificationType);
        }
    }
}
