package ru.yandex.wmconsole.data.bad.urls.impl;

import ru.yandex.wmconsole.data.bad.urls.DbTask;
import ru.yandex.wmconsole.data.bad.urls.RequestDispatcher;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmconsole.util.file.comparator.impl.UrlRecord;
import ru.yandex.wmtools.common.util.URLUtil;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

/**
 * User: azakharov
 * Date: 15.08.13
 * Time: 11:13
 */
public class RequestDispatcherImpl implements RequestDispatcher {
    private final BlockingQueue<DbTask>[] queues;
    private final int dbCount;

    public RequestDispatcherImpl(int dbCount) {
        this.dbCount = dbCount;
        this.queues = new BlockingQueue[dbCount];
        for (int i = 0; i < dbCount; i++) {
            queues[i] = new ArrayBlockingQueue<DbTask>(1024);
        }
    }

    @Override
    public void addRequest(DbTask task) throws InterruptedException {
        final DbTask eof = EndOfFileDbTask.getInstance();
        if (eof.equals(task)) {
            // put end of file task to all queues;
            for (int i = 0; i < queues.length; i++) {
                queues[i].put(eof);
            }
            return;
        }
        UrlRecord record = task.getNewUrlRecord() != null ? task.getNewUrlRecord() : task.getOldUrlRecord();
        String hostName = URLUtil.getHostName(record.getKey(), false);
        int index = WMCPartition.getDatabaseIndex(dbCount, hostName);
        if (index >= 0 && index < queues.length) {
            queues[index].put(task);
        }
    }

    public BlockingQueue<DbTask> getQueue(int dbIndex) {
        return queues[dbIndex];
    }
}
