package ru.yandex.wmconsole.data.info;

import wmc.stubs.Stubs;

/**
 * @author avhaliullin
 */
public class AllowInfo {
    private boolean allowed;
    private String rule;
    private boolean syntaxError;
    private String changedUrl;

    public AllowInfo(boolean allowed, String rule, boolean syntaxError, String changedUrl) {
        this.allowed = allowed;
        this.rule = rule;
        this.syntaxError = syntaxError;
        this.changedUrl = changedUrl;
    }

    public AllowInfo(Stubs.allow_info oldInfo) {
        this(oldInfo.getAllowed(), oldInfo.getRule(), hasSyntaxError(oldInfo), getChangedUrl(oldInfo));
    }

    public boolean isAllowed() {
        return allowed;
    }

    public String getRule() {
        return rule;
    }

    public boolean isSyntaxError() {
        return syntaxError;
    }

    public String getChangedUrl() {
        return changedUrl;
    }

    private static boolean hasSyntaxError(Stubs.allow_info oldInfo) {
        return oldInfo.hasType() ? oldInfo.getType() == Stubs.url_error_type.ERR_URL_SYNTAX : false;
    }

    private static String getChangedUrl(Stubs.allow_info oldInfo) {
        return oldInfo.hasChangedUrl() ? oldInfo.getChangedUrl() : null;
    }
}
