package ru.yandex.wmconsole.data.info;


import wmc.stubs.Stubs;

import java.util.ArrayList;
import java.util.List;

/**
 * @author avhaliullin
 */
public class AnalysisResult {
    private final List<ErrorInfo> errors;
    private final List<Long> acceptedLines;
    private final List<AllowInfo> areAllowed;

    public AnalysisResult(List<ErrorInfo> errors, List<Long> acceptedLines, List<AllowInfo> areAllowed) {
        this.errors = errors;
        this.acceptedLines = acceptedLines;
        this.areAllowed = areAllowed;
    }

    private static List<ErrorInfo> getErrors(Stubs.analysis_result_msg msg) {
        List<ErrorInfo> res = new ArrayList<ErrorInfo>();
        for (Stubs.error_info oldInfo : msg.getErrorsList()) {
            res.add(new ErrorInfo(oldInfo));
        }
        return res;
    }

    private static List<AllowInfo> getAllowInfo(Stubs.analysis_result_msg msg) {
        List<AllowInfo> res = new ArrayList<AllowInfo>();
        for (Stubs.allow_info oldInfo : msg.getAreAllowedList()) {
            res.add(new AllowInfo(oldInfo));
        }
        return res;
    }

    public AnalysisResult(Stubs.analysis_result_msg msg) {
        this(getErrors(msg), msg.getAcceptedLinesList(), getAllowInfo(msg));
    }

    public List<ErrorInfo> getErrors() {
        return errors;
    }

    public List<Long> getAcceptedLines() {
        return acceptedLines;
    }

    public List<AllowInfo> getAreAllowed() {
        return areAllowed;
    }
}
