package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.AvailableEnum;

import java.util.Date;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
*/
public class AvailableInfo {
    private final AvailableEnum available;
    private final String filename;
    private final Long size;
    private final Date date;

    private static AvailableInfo notReady = new AvailableInfo(AvailableEnum.NOT_READY, null, null, null);

    private static AvailableInfo optionDisabled = new AvailableInfo(AvailableEnum.OPTION_DISABLED, null, null, null);

    public AvailableInfo(AvailableEnum available, String filename, Long size, Date date) {
        this.available = available;
        this.filename = filename;
        this.size = size;
        this.date = date;
    }

    public static AvailableInfo createNotReady() {
        return notReady;
    }

    public static AvailableInfo createOptionDisabled() {
        return optionDisabled;
    }

    public AvailableEnum getAvailable() {
        return available;
    }

    public String getFilename() {
        return filename;
    }

    public Long getSize() {
        return size;
    }

    public Date getDate() {
        return date;
    }
}
