package ru.yandex.wmconsole.data.info;

/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 22.03.2007
* Time: 21:43:03
*/
public class BriefHostInfo implements Comparable<BriefHostInfo> {
    private final long id;
    private final String name;
    private final Long mainMirrorId;

    public BriefHostInfo(final long id, final String name, final Long mainMirrorId) {
        this.id = id;
        this.name = name;
        this.mainMirrorId = mainMirrorId;
    }

    public long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public Long getMainMirrorId() {
        return mainMirrorId;
    }

    @Override
    public int compareTo(BriefHostInfo info) {
        if (id > info.getId()) {
            return 1;
        }

        if (id < info.getId()) {
            return -1;
        }

        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BriefHostInfo)) {
            return false;
        }
        BriefHostInfo other = (BriefHostInfo) o;

        return compareTo(other) == 0;
    }

    public int hashCode() {
        return (int) id;
    }

    public String toString() {
        return "BriefHostInfo. name: " + name + "; id: " + id;
    }
}
