package ru.yandex.wmconsole.data.info;

import ru.yandex.common.framework.user.UserInfo;

import java.util.Date;

/**
 * @author baton
 */
public class DelegationInfo {
    private final long id;
    private final long hostId;
    private final long userIdGave;
    private final boolean mayRedelegate;
    private final UserInfo userGotInfo;
    private final boolean hostAddedByUser;
    private final Date delegationDate;

    public DelegationInfo(long id, long hostId, long userIdGave, UserInfo userGotInfo, boolean mayRedelegate, boolean hostAddedByUser, Date delegationDate) {
        this.id = id;
        this.hostId = hostId;
        this.userIdGave = userIdGave;
        this.mayRedelegate = mayRedelegate;
        this.userGotInfo = userGotInfo;
        this.hostAddedByUser = hostAddedByUser;
        this.delegationDate = delegationDate;
    }

    public long getId() {
        return id;
    }

    public long getHostId() {
        return hostId;
    }

    public long getUserIdGave() {
        return userIdGave;
    }

    public boolean isMayRedelegate() {
        return mayRedelegate;
    }

    public UserInfo getUserGotInfo() {
        return userGotInfo;
    }

    public boolean isHostAddedByUser() {
        return hostAddedByUser;
    }

    public Date getDelegationDate() {
        return delegationDate;
    }
}
