package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.LanguageEnum;
import ru.yandex.wmconsole.data.WMCHistoryObjectTypeEnum;
import ru.yandex.wmtools.common.data.IHistoryAction;
import ru.yandex.wmtools.common.data.info.WMUserInfo;

import java.util.Date;

/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 22.03.2007
* Time: 15:45:34
*/
public class DraftMessageInfo {
    private final long messageId;
    private final WMUserInfo lastEditor;
    private final Date lastAccess;
    private final String header;
    private final String content;
    private final IHistoryAction state;
    private final WMCHistoryObjectTypeEnum type;
    private final LanguageEnum language;

    public DraftMessageInfo(
            long messageId,
            WMUserInfo lastEditor,
            String header,
            String content,
            IHistoryAction state,
            Date lastAccess,
            WMCHistoryObjectTypeEnum type,
            LanguageEnum language) {

        this.messageId = messageId;
        this.lastEditor = lastEditor;
        this.lastAccess = lastAccess;
        this.header = header;
        this.content = content;
        this.state = state;
        this.type = type;
        this.language = language;
    }

    public long getMessageId() {
        return messageId;
    }

    public String getHeader() {
        return header;
    }

    public String getContent() {
        return content;
    }

    public IHistoryAction getState() {
        return state;
    }

    public Date getLastAccess() {
        return lastAccess;
    }

    public WMCHistoryObjectTypeEnum getType() {
        return type;
    }

    public WMUserInfo getLastEditor() {
        return lastEditor;
    }

    public LanguageEnum getLanguage() {
        return language;
    }

    public Integer getLang() {
        return language != null ? language.getId() : null;
    }
}
