package ru.yandex.wmconsole.data.info;


import wmc.stubs.Stubs;

/**
 * @author avhaliullin
 */
public class ErrorInfo {
    private final FormatErrorType type;
    private final long lineNumber;

    public ErrorInfo(FormatErrorType type, long lineNumber) {
        this.type = type;
        this.lineNumber = lineNumber;
    }

    public ErrorInfo(Stubs.error_info oldInfo) {
        this(FormatErrorType.R.fromValueOrNull(oldInfo.getType().getNumber()), oldInfo.getLineNum());
    }

    public long getLineNumber() {
        return lineNumber;
    }

    public FormatErrorType getType() {
        return type;
    }
}
